% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_points}
\alias{plot_points}
\title{Add Points to a Circular Plot}
\usage{
plot_points(
  x,
  axial = TRUE,
  stack = FALSE,
  binwidth = 1,
  cex = 1,
  sep = 0.025,
  jitter_factor = 0,
  ...,
  scale = 1.1,
  add = TRUE,
  main = NULL,
  labels = TRUE,
  at = seq(0, 360 - 45, 45),
  cborder = TRUE
)
}
\arguments{
\item{x}{Data to be plotted. A numeric vector containing angles (in degrees).}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})
or biaxial (\code{TRUE}, the default).}

\item{stack}{logical: if \code{TRUE}, points are stacked on the perimeter of the
circle.
Otherwise, all points are plotted on the perimeter of the circle. Default is
\code{FALSE}.}

\item{binwidth}{numeric. Bin width (in degrees) for the stacked dot plots.
ignored when \code{stack==FALSE}. Is set to \code{1} degree by default.}

\item{cex}{character (or symbol) expansion: a numerical vector. This works as
a multiple of \code{par("cex")}.}

\item{sep}{constant used to specify the distance between stacked points, if
\code{stack==TRUE} or in the case of more than one dataset. Default is \code{0.025};
smaller values will create smaller spaces.}

\item{jitter_factor}{numeric. Adds a small amount of random variation to the
location of each points along radius that is added to \code{scale}. Jitter is
ignored when \code{stack==TRUE}). If \code{0}, no jitter is added (by default); if
negative, the points fall into the circle.}

\item{...}{Further graphical parameters may also be supplied as arguments.}

\item{scale}{radius of plotted circle. Default is \code{1.1}.
Larger values shrink the circle, while smaller values enlarge the circle.}

\item{add}{logical}

\item{main}{Character string specifying the title of the plot.}

\item{labels}{Either a logical value indicating whether to plot labels
next to the tick marks, or a vector of labels for the tick marks.}

\item{at}{Optional vector of angles at which tick marks should be plotted.
Set \code{at=numeric(0)} to suppress tick marks.}

\item{cborder}{logical. Border of rose plot.}
}
\value{
A list with information on the plot
}
\description{
Add points to a plot of circular data points on the current graphics device.
}
\examples{
x <- rvm(100, mean = 90, k = 5)

# plot poinit without jitter
plot_points(x, add = FALSE)

# with some jitter
plot_points(x, jitter_factor = .2, add = FALSE)

# stacked dots:
plot_points(x, stack = TRUE, binwidth = 3, add = FALSE)
}
