% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_rmarkdown.R
\name{tm_rmarkdown}
\alias{tm_rmarkdown}
\title{\code{teal} module: R Markdown render}
\usage{
tm_rmarkdown(
  label = "RMarkdown Module",
  rmd_content,
  datanames = "all",
  allow_download = TRUE,
  pre_output = NULL,
  post_output = NULL,
  transformators = list(),
  extra_transform = list()
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{rmd_content}{(\code{character}) Content of the R Markdown file to be rendered.
This can be the value of \code{readLines("path/to/file.Rmd")}.}

\item{datanames}{(\code{character}) Names of the datasets relevant to the item.
There are 2 reserved values that have specific behaviors:
\itemize{
\item The keyword \code{"all"} includes all datasets available in the data passed to the teal application.
\item \code{NULL} hides the sidebar panel completely.
\item If \code{transformators} are specified, their \code{datanames} are automatically added to this \code{datanames}
argument.
}}

\item{allow_download}{(\code{logical}) whether to allow downloading of the R Markdown file.
Defaults to \code{TRUE}.}

\item{pre_output}{(\code{shiny.tag}) optional, text or UI element to be displayed before the module's output,
providing context or a title.
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}) optional, text or UI element to be displayed after the module's output,
adding context or further instructions. Elements like \code{shiny::helpText()} are useful.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{extra_transform}{(\code{list}) of \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} that will be added in the module's UI.
This can be used to create interactive inputs that modify the parameters in R Markdown rendering.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Module to render R Markdown files using the data provided in the
\code{teal_data} object.

The R Markdown file should be designed to accept variables available
in the data names of the module.
}
\details{
For example, if the \code{teal_data} object contains datasets named \code{mtcars}
and \code{iris}, the R Markdown file can use these as variables as they
will be available in the R Markdown environment.

The libraries used in the R Markdown file must be available in the
deployed shiny app environment.

When developing the R Markdown file, the working data can be simulated
on a code chunk, which in turn can look for the presence of \code{.raw_data}
object to determine if it is being run inside the \code{teal} module or not.

Example R markdown file:

\if{html}{\out{<div class="sourceCode md">}}\preformatted{---
title: "R Markdown Report"
output: html_document
---

```\{r eval=!exists(".raw_data")\}
mtcars <- datasets::mtcars
iris <- datasets::iris
```

```\{r\}
summary(mtcars) |> print()
summary(iris) |> print()
```
}\if{html}{\out{</div>}}
}
\section{Reporting}{



This module returns an object of class \code{teal_module}, that contains a \code{server} function.
Since the server function returns a \code{teal_report} object, this makes this module reportable, which means that
the reporting functionality will be turned on automatically by the \code{teal} framework.

For more information on reporting in \code{teal}, see the vignettes:
\itemize{
\item \code{vignette("reportable-shiny-application", package = "teal.reporter")}
\item \code{vignette("adding-support-for-reporting-to-custom-modules", package = "teal")}
}

}

\examples{

# general data example
data <- teal_data()
data <- within(data, {
  CO2 <- CO2
})

app <- init(
  data = data,
  modules = modules(
    tm_rmarkdown(
      label = "RMarkdown Module",
      rmd_content = c(
        "---",
        "title: \"R Markdown Report\"",
        "output: html_document",
        "---",
        "",
        "```{r}",
        "summary(CO2) |> print()",
        "```"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

nrow_transform <- teal_transform_module(
  label = "N Rows selector",
  ui = function(id) {
    ns <- NS(id)
    tags$div(
      numericInput(ns("n_rows"), "Show n rows", value = 40, min = 0, max = 200, step = 5)
    )
  },
  server = function(id, data) {
    moduleServer(id, function(input, output, session) {
      reactive({
        req(data())
        within(data(),
          {
            n_rows <- n_rows_value
          },
          n_rows_value = input$n_rows
        )
      })
    })
  }
)

app <- init(
  data = data,
  modules = modules(
    tm_rmarkdown(
      label = "RMarkdown Module",
      rmd_content = readLines(
        system.file(
          file.path("sample_files", "co2_example.Rmd"),
          package = "teal.modules.general"
        )
      ),
      allow_download = FALSE,
      extra_transform = list(nrow_transform)
    )
  )
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMAcwpxm1AJQAdCLTIyoBUrQBucAAQAeALS6AZoIgbaJdnN0AVLAFUAokrcQAxLqkQ11XfxQpFC6cAAesKgiSoHBBsZc1AD6sVA2MUEhRroA7rSkABYq7Km4uiBKuroAwgDyAEzxNQ1KAL6KEEpoqE0q+eyVAZm6ALxDwbiDfEIioqO608JiAxBVVaQwSYwwLADW-EQ5ECtra9RQ9HD+YwpgWACyewdHuvcCS7eTq6e62-xJxFUZHmBBOPyqt0MUM+g3Bt00pBEiF0ClRd1eT0OqywcFQREYpFRtxh3zhYCIglIqEpyIKG2SBwIgngZBJ4IhYChhjZ7OJeFhP1uAAMRSBGK0eWTRMydmx2HV6rYAD4APl0qEYKlI6X5pMFYBFQuJeqqHVOZt0HQ6tBMunYWrUlh0NlsFW+oiKEFYAEF0OxugASQS0MqB0QyHSMDoSiBgVoAXSAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMAcwpxm1AJQAdCLTIyoBUrQBucAAQAeALS6AZoIgbaJdnN0AVLAFUAokrcQAxLqkQ11XfxQpFC6cAAesKgiSoHBBsZc1AD6sVA2MUEhRroA7rSkABYq7Km4uiBKuroAwgDyAEzxNQ1KAL6KEEpoqE0q+eyVAZm6ALxDwbiDfEIioqO608JiAxBVVaQwSYwwLADW-EQ5ECtra9RQ9HD+YwpgWACyewdHuvcCS7eTq6e62-xJxFUZHmBBOPyqt0MUM+g3Bt00pBEiF0ClRd1eT0OqywcFQREYpFRtxh3zhYCIglIqEpyIKG2SBwIgngZBJ4IhYChhjZ7OJeFhP1uAAMRSBGK0eWTRMydmx2HV6rYAD4APl0qEYKlI6X5pMFYBFQuJeqqHVOZt0HQ6tBMunYWrUlh0NlsFW+oiKEFYAEF0OxugASQS0MqB0QyHSMDoSiBgVoAXSAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

