% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-blur-sigmas.R
\name{blur_sigmas}
\alias{blur_sigmas}
\title{Standard deviation of Gaussian blur}
\usage{
blur_sigmas(range = c(unknown(), unknown()), trans = transform_log1p())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A \code{param} object or list of \code{param} objects.
}
\description{
The standard deviation of the noise function convolved with
array values to induce blur in raster data.
}
\details{
The gaussian blur step deploys \code{\link[=blur]{blur()}}. See there for definitions
and references.

\code{get_blur_range()} varies the parameter logarithmically from 0 to an order
of magnitude greater than the \code{\link[=blur]{blur()}} default.
}
\examples{
img_dat <- data.frame(img = I(list(volcano)))

(blur_man <- blur_sigmas(range = c(0, 3)))
grid_regular(blur_man)

(blur_fin <- blur_sigmas() \%>\% get_blur_range(x = img_dat))
grid_regular(blur_fin)
}
