% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project_list}
\alias{project_list}
\title{List All Projects}
\usage{
project_list(con = NULL)
}
\arguments{
\item{con}{An optional database connection. If NULL, a new connection is
created and closed automatically.}
}
\value{
A data frame with one row per project, or NULL if no projects exist.
  Columns include: id, name, table, status, and memory.
}
\description{
Retrieves information about all projects in the database.
}
\details{
Returns NULL if the project table doesn't exist (i.e., \code{\link{db_init}}
has not been called).
}
\examples{
\dontrun{
# Not run:
# List all projects
projects <- project_list()
print(projects)

# Find running projects
running <- projects[projects$status == TRUE, ]
}
}
\seealso{
\code{\link{project_add}}, \code{\link{project_get}}
}
