% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_with.R
\name{tar_option_with}
\alias{tar_option_with}
\title{Locally set target options.}
\usage{
tar_option_with(expression, ..., envir_with = parent.frame())
}
\arguments{
\item{expression}{An R expression to run with the local option.}

\item{...}{Named arguments to \code{\link[=tar_option_set]{tar_option_set()}} to temporarily set
for the duration of \code{expression}.}

\item{envir_with}{Environment to evaluate \code{expression}.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Locally set target options for the duration
of an expression, without permanently modifying the global state.
}
\examples{
  tar_option_with(
    tar_target(data, get_data()),
    packages = "dplyr",
    cue = tar_cue(mode = "never")
  )
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_projects}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
