% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_timing_atc_group}
\alias{plot_timing_atc_group}
\alias{plot_timing_atc_group.medic}
\alias{plot_timing_atc_group.summary.medic}
\alias{plot_timing_atc_group.timing_atc_group}
\title{Plot Timing ATC Group}
\usage{
plot_timing_atc_group(object, ...)

\method{plot_timing_atc_group}{medic}(object, ...)

\method{plot_timing_atc_group}{summary.medic}(object, ...)

\method{plot_timing_atc_group}{timing_atc_group}(
  object,
  focus = "average",
  with_population = FALSE,
  max_lines = 50,
  ...
)
}
\arguments{
\item{object}{The object containing the timing ATC group data.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{focus}{The focus of the plot. Must be either "average", "individual" or
"both".}

\item{with_population}{Logical value indicating whether to include the
population cluster.}

\item{max_lines}{The maximum number of lines to plot.}
}
\value{
A ggplot object.
}
\description{
This function plots the timing ATC group.
}
\examples{
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3:5,
  timing = first_trimester:third_trimester
)

clust |> plot_timing_atc_group()
clust |> timing_atc_group() |> plot_timing_atc_group()
clust |> summary() |> plot_timing_atc_group()

}
\seealso{
\code{\link{timing_atc_group}}

\code{\link{plot_cluster_frequency}}

\code{\link{plot_medication_frequency}}

\code{\link{plot_comedication_count}}

\code{\link{plot_timing_trajectory}}

\code{\link{plot_summary}}
}
