% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cluster_frequency}
\alias{plot_cluster_frequency}
\alias{plot_cluster_frequency.medic}
\alias{plot_cluster_frequency.summary.medic}
\alias{plot_cluster_frequency.cluster_frequency}
\title{Plot Cluster Frequency}
\usage{
plot_cluster_frequency(object, ...)

\method{plot_cluster_frequency}{medic}(object, ...)

\method{plot_cluster_frequency}{summary.medic}(object, ...)

\method{plot_cluster_frequency}{cluster_frequency}(object, scale = "percent", with_population = FALSE, ...)
}
\arguments{
\item{object}{The object containing the cluster frequency data.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{scale}{The scale of the y-axis. Must be either "percent" or "count".}

\item{with_population}{Logical value indicating whether to include the
population cluster.}
}
\value{
A ggplot object.
}
\description{
This function plots the cluster frequency.
}
\examples{
clust <- medic(complications, id = id, atc = atc, k = 3)
clust |> plot_cluster_frequency()
clust |> cluster_frequency() |> plot_cluster_frequency()
clust |> summary() |> plot_cluster_frequency()

}
\seealso{
\code{\link{cluster_frequency}}

\code{\link{plot_medication_frequency}}

\code{\link{plot_comedication_count}}

\code{\link{plot_timing_trajectory}}

\code{\link{plot_timing_atc_group}}

\code{\link{plot_summary}}
}
