% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cats.R
\name{read_cats}
\alias{read_cats}
\title{Read CATS csv data file(s) and convert to .nc}
\usage{
read_cats(
  file_dir = NULL,
  fname = NULL,
  depid,
  txt_fname = NULL,
  nc_dir = getwd(),
  nc_fname = paste(depid, "_raw.nc", sep = ""),
  device_serial = NULL,
  device_model_name = NULL,
  device_model_version = NULL,
  device_url = "https://cats.is/",
  dephist_device_tzone = NULL,
  animal_species_common = "unknown",
  animal_species_science = "unknown"
)
}
\arguments{
\item{file_dir}{String containing the name (including full or relative path) of the directory where the CATS csv file(s) are stored. If omitted, \code{fname} must include full or relative path information for the csv file(s).}

\item{fname}{Name(s) of the CATS csv file(s) to read. If \code{fname} is not provided, then the function will try to read all csv files in \code{file_dir}. If \code{file_dir} is provided, the path(s) to the file(s) will be constructed by appending the file name(s) to the \code{file_dir}. 
If \code{file_dir} is omitted, then \code{fname} is assumed to include the path to the file(s). The .csv file extension is optional.}

\item{depid}{String containing the deployment identification code assigned
to this deployment, for example, 'mn12_186a'. If \code{fname} is not input, csv files are assumed to have names of the form "\code{depid}_001.csv" (002, 003 etc if multiple files) or "\code{depid}.csv" (if data is in a single file).}

\item{txt_fname}{Name of the .txt file with metadata about the CATS deployment. If not input, the function will try to construct it from file_dir and depid (like \code{file.path(file_dir, paste0(depid, ".txt"))}). 
If present, this file will be used to determine sensor sampling rates; if not, sampling rates will be guessed based on timestamps in the csv file.}

\item{nc_dir}{String containing the name (including full or relative path) of the directory where the output nc file should be stored. Defaults to the current working directory.}

\item{nc_fname}{String containing the file name to use for the output netCDF file. Defaults to "(depid)_raw.nc" - for example, "mn12_186a_raw.nc"}

\item{device_serial}{String containing the serial number of the CATS tag. Obtained from \code{txt_fname} or else defaults to NULL; stored in the info structure of the output NetCDF file.}

\item{device_model_name}{String containing the model of the CATS tag used for data collection, for example "CATS Cam." Obtained from \code{txt_fname} or else defaults to NULL. This information is stored in the info structure of the output NetCDF file.}

\item{device_model_version}{String; CATS tag version. Obtained from \code{txt_fname} or else defaults to NULL; stored in the info structure of the output NetCDF file.}

\item{device_url}{String containing URL of tag manufacturer; defaults to "https://cats.is/" and is stored in the info structure of the output NetCDF file.}

\item{dephist_device_tzone}{String indicating the time zone in which the tag was deployed. Obtained by default from \code{txt_fname} or else defaults to NULL. Stored in the info structure of the output NetCDF file. For CATS tags this is the local offset from UTC time in hours.}

\item{animal_species_common}{Common name of species on which tag was deployed. Defaults to "unknonwn" and is stored in the info structure of the output NetCDF file.}

\item{animal_species_science}{Scientific name of species on which tag was deployed. Defaults to "unknonwn" and is stored in the info structure of the output NetCDF file.}
}
\value{
A string containing the file name of the netCDF (.nc) file in which the output has been saved. This function
generates a netCDF file in the current working directory containing
		the tag data variables, including:
		\itemize{
		\item {A, Accelerometer data structure}
		\item {M, Magnetometer data structure}
		\item {temp, Temperature sensor data structure}
		\item {info	Information structure for the deployment}
		}
}
\description{
Read .csv file(s) with data from a CATS tag deployment, including associated metadata, and store the resulting data in a .nc file.
}
\note{
CATS loggers can produce very large csv files which are slow to
process. This function is (somewhat) optimised for speed and memory use so will
tolerate large files. But processing could be slow. Note also that although CATs tags use a NED axis orientation for 3D sensors, 
**this function converts to the NEU orientation** expected by the animaltag tool kit. 
To revert (if continuing analysis with CATs-specific tools outside animaltags), 
simply multiply all z-axis values by -1, and consider editing the metadata. 
Also note that according to Cade et al. 2021, not all CATs tags have the same internal orientation of the triaxial sensors -- 
such that the first column in the data may or may not be the "x axis." 
Here, we assume that the three columns of data for any triaxial sensor are correctly labeled with X,Y,Z included in the column name in the CATs csv file. 
If not, further data-based bench calibration of the device may be needed to determine correct axis orientation.
}
\examples{
\dontrun{
nc_filename <- read_cats("my_cats_file.csv", "my_cats_deployment_name")
load_nc(nc_filename)
}
}
