% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/similarity.R
\docType{methods}
\name{index_morisita}
\alias{index_morisita}
\alias{index_morisita-method}
\alias{index_morisita,numeric,numeric-method}
\title{Morisita-Horn Quantitative Index}
\usage{
index_morisita(x, y, ...)

\S4method{index_morisita}{numeric,numeric}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Horn modified version of the Morisita overlap index.
}
\references{
Horn, H. S. (1966). Measurement of "Overlap" in Comparative Ecological
Studies. \emph{The American Naturalist}, 100(914): 419-424. \doi{10.1086/282436}.

Mosrisita, M. (1959). Measuring of interspecific association and similarity
between communities. \emph{Memoirs of the Faculty of Science, Kyushu University},
Series E, 3:65-80.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_binomial}()},
\code{\link{index_brainerd}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_routledge}},
\code{\link{index_sorensen}()},
\code{\link{index_whittaker}()},
\code{\link{index_wilson}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
