% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity.R
\docType{methods}
\name{evenness}
\alias{evenness}
\alias{evenness-method}
\alias{evenness,matrix-method}
\alias{evenness,data.frame-method}
\title{Evenness}
\usage{
evenness(object, ...)

\S4method{evenness}{matrix}(
  object,
  ...,
  method = c("shannon", "simpson", "brillouin", "mcintosh")
)

\S4method{evenness}{data.frame}(
  object,
  ...,
  method = c("shannon", "simpson", "brillouin", "mcintosh")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods (see below).}

\item{method}{A \code{\link{character}} string specifying the index to be computed
(see details). Any unambiguous substring can be given.}
}
\value{
An \linkS4class{EvennessIndex} object.
}
\description{
Computes an evenness measure.
}
\details{
\emph{Evenness} is a measure of how evenly individuals are distributed across the
sample.

The following evenness measures are available (see Magurran 1988 for
details):
\describe{
\item{\code{brillouin}}{\link[=index_brillouin]{Brillouin diversity index}.}
\item{\code{mcintosh}}{\link[=index_mcintosh]{McIntosh dominance index}.}
\item{\code{shannon}}{\link[=index_shannon]{Shannon-Wiener diversity index}.}
\item{\code{simpson}}{\link[=index_simpson]{Simpson dominance index}.}
}
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Alpha diversity
diversity(cantabria)

## Shannon diversity index
(h <- heterogeneity(cantabria, method = "shannon"))
(e <- evenness(cantabria, method = "shannon"))

as.data.frame(h)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press.
\doi{10.1007/978-94-015-7358-0}.
}
\seealso{
\code{\link[=index_brillouin]{index_brillouin()}}, \code{\link[=index_mcintosh]{index_mcintosh()}}, \code{\link[=index_shannon]{index_shannon()}},
\code{\link[=index_simpson]{index_simpson()}}

Other diversity measures: 
\code{\link{diversity}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
