% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{escape_latex.latex}
\alias{escape_latex.latex}
\title{Escape Latex for Class 'latex'}
\usage{
\method{escape_latex}{latex}(x, secondary = TRUE, primary = FALSE, ...)
}
\arguments{
\item{x}{latex}

\item{secondary}{logical: whether first backslashes should be pre-doubled}

\item{...}{ignored}
}
\value{
latex
}
\description{
Returns argument typically unmodified.
Prevents accidental double-escaping
of the same text.
}
\details{
This function is used in \code{\link{as_kable.tablet}} in
preparation for a call to \code{\link[kableExtra]{kbl}}.
At kableExtra 1.3.4, sim_double_escape() only doubles
primary (leading) backslashes; the \code{secondary} argument
by default pre-doubles later backslashes to prevent
certain display errors.  Behavior may change if kableExtra changes.
}
\examples{
identical(
escape_latex('([#$\%&_{}])'),
escape_latex(escape_latex('([#$\%&_{}])'))
)

}
\seealso{
Other escape: 
\code{\link{escape_latex}()},
\code{\link{escape_latex.default}()}
}
\concept{escape}
\keyword{internal}
