% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Section13}
\alias{Section13}
\alias{swe_houses_ex}
\alias{swe_houses_armc}
\alias{swe_house_name}
\title{Section 13: House cusp, ascendant and Medium Coeli calculations}
\usage{
swe_houses_ex(jd_ut, cuspflag, geolat, geolon, hsys)

swe_houses_armc(armc, geolat, eps, hsys)

swe_house_name(hsys)
}
\arguments{
\item{jd_ut}{UT Julian day number as double (day)}

\item{cuspflag}{cusp flag as integer (0 [tropical], SE$FLG_SIDEREAL, SE$FLG_RADIANS)}

\item{geolat}{geographic latitude as double (deg)}

\item{geolon}{geographic longitude as double (deg)}

\item{hsys}{house method, one-letter case sensitive as char}

\item{armc}{right ascension of the MC as double (deg)}

\item{eps}{ecliptic obliquity as double (deg)}
}
\value{
\code{swe_houses_ex} returns a list with named entries: \code{return} status flag as integer,
     \code{cusps} cusps values as double and \code{ascmc} ascendent, MCs. etc. as double.

\code{swe_houses_armc} returns a list with named entries: \code{return} status flag as integer,
     \code{cusps} cusps values as double and \code{ascmc} ascendent, MCs, etc. as double.

\code{swe_house_name} returns the house name as string
}
\description{
Calculate house cusp, ascendant, Medium Coeli, etc. calculations
}
\details{
\describe{
\item{swe_houses_ex()}{Calculate houses' cusps, ascendant, Medium Coeli (MC), etc.}
}

\describe{
\item{swe_houses_armc()}{Calculate houses' information from the right ascension of the Medium Coeli (MC).}
}

\describe{
\item{swe_houses_name()}{Provide the house name.}
}
}
\examples{
swe_houses_ex(1234567, 0, 53, 0, 'B')
swe_houses_armc(12, 53, 23, 'B')
swe_house_name('G')
}
\seealso{
Section 13 in \url{https://www.astro.com/swisseph/swephprg.htm}. Remember that array indices start in R at 1, while in C they start at 0!
}
