% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susieR-package.R
\docType{package}
\name{susieR-package}
\alias{susieR}
\alias{susieR-package}
\title{susieR: Sum of Single Effects Linear Regression}
\description{
Implements methods for variable selection in linear
    regression based on the "Sum of Single Effects" (SuSiE) model, as
    described in Wang et al (2020) <DOI:10.1101/501114> and Zou et al
    (2021) <DOI:10.1101/2021.11.03.467167>. These methods provide
    simple summaries, called "Credible Sets", for accurately
    quantifying uncertainty in which variables should be selected.
    The methods are motivated by genetic fine-mapping applications,
    and are particularly well-suited to settings where variables are
    highly correlated and detectable effects are sparse. The fitting
    algorithm, a Bayesian analogue of stepwise selection methods
    called "Iterative Bayesian Stepwise Selection" (IBSS), is simple
    and fast, allowing the SuSiE model be fit to large data sets
    (thousands of samples and hundreds of thousands of variables).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/stephenslab/susieR}
  \item Report bugs at \url{https://github.com/stephenslab/susieR/issues}
}

}
\author{
\strong{Maintainer}: Peter Carbonetto \email{peter.carbonetto@gmail.com}

Authors:
\itemize{
  \item Gao Wang \email{wang.gao@columbia.edu}
  \item Yuxin Zou
  \item Kaiqian Zhang
  \item Matthew Stephens
}

}
\keyword{internal}
