% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{cetux}
\alias{cetux}
\alias{cetux_seer}
\alias{cetux_bh}
\title{Datasets for evaluation of cetuximab in head and neck cancer}
\format{
\code{cetux} contains synthetic individual-level survival
data, generated (using the method of Guyot et al 2012) to be
consistent with the Kaplan-Meier estimates of survival published
by Bonner et al. (2006).
Columns \code{months}, \code{years}, give survival in months or
years since the date of diagnosis of head and neck cancer.
\code{d} is a numeric vector where 0 indicates censoring, and 1
indicates death at this time.  \code{treat} is a factor indicating
the treatment group (Cetuximab or Control); both groups also
received radiotherapy.

\code{cetux_seer} Estimates of conditional survival from registry data,
matched to the Bonner trial population by age, gender, cancer site, and date of diagnosis.
From the "Surveillance Epidemiology and End Results" (SEER) database.
Each line gives counts of \code{r} survivors up to \code{stop} years,
given \code{n} people alive at \code{start}.  \code{haz} is the
corresponding constant hazard estimate over this period, computed
as \code{-log(r/n)}.
There are also 95\% interval estimates for the hazard based on the data
on one period at a time, derived
from Bayesian principles as \code{-log(qbeta(c(0.975, 0.025), r, n-r))}.

\code{cetux_bh} Mortality rates for the population of the
USA, matched by age and sex to the patients from the Bonner trial.
80\% are male, and the median age is 57 (range 34 to 83).  Hence
the \eqn{i}th row is a weighted average of the male and
and female mortality rates for age \eqn{57 + i - 1}.

See Guyot et al. (2017) for more details of each of these.

An object of class \code{data.frame} with 424 rows and 4 columns.

An object of class \code{data.frame} with 21 rows and 8 columns.

An object of class \code{data.frame} with 54 rows and 2 columns.
}
\usage{
cetux

cetux_seer

cetux_bh
}
\description{
Datasets for evaluation of cetuximab in head and neck cancer, as previously
analysed by \href{https://journals.sagepub.com/doi/pdf/10.1177/0272989X16670604}{Guyot et al. (2017)} to demonstrate models for survival extrapolation
with Bayesian evidence synthesis.
}
\references{
Guyot, P., Ades, A.E., Beasley, M., Lueza, B., Pignon, J.P. and
Welton, N.J., (2017). Extrapolation of survival curves from cancer
trials using external information. Medical Decision Making, 37(4),
pp.353-366.

Bonner, J.A., Harari, P.M., Giralt, J., Azarnia, N., Shin, D.M.,
Cohen, R.B., Jones, C.U., Sur, R., Raben, D., Jassem, J. and Ove,
R., (2006) Radiotherapy plus cetuximab for squamous-cell carcinoma
of the head and neck. New England Journal of Medicine, 354(6),
pp.567-578.

Guyot, P., Ades, A.E., Ouwens, M.J. and Welton, N.J.,
(2012) Enhanced secondary analysis of survival data: reconstructing
the data from published Kaplan-Meier survival curves. BMC Medical
Research Methodology, 12, pp.1-13.
}
\keyword{datasets}
