% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_check.R
\name{bind_as_struct}
\alias{bind_as_struct}
\title{Bind as Struct}
\usage{
bind_as_struct(template, ..., strict = FALSE)
}
\arguments{
\item{template}{A named list to use as a template.}

\item{...}{The lists to join}

\item{strict}{Use all and only the fields in the template. Default: FALSE}
}
\value{
A dataframe containing the combined inputs.
}
\description{
Given a set of lists/dataframes, attempt to join them as a dataframe with field
types matching the specified template. The default and fastest approach simply
relies on \code{dplyr::bind_rows} to use all fields present in the lists to be
joined, while strict mode ensures that the template fields and only the template
fields are present.
}
\examples{
bind_as_struct(list("a" = character(0)), list("a" = 1), list("a" = "a"))
}
