% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{get_interpolated_expr}
\alias{get_interpolated_expr}
\alias{get_interpolated_vars}
\title{Lists the expressions used for interpolation in a \code{string_magic} call}
\usage{
get_interpolated_expr(x, parse = FALSE, delim = c("{", "}"))

get_interpolated_vars(x, delim = c("{", "}"))
}
\arguments{
\item{x}{A character scalar for which the variables will be recovered.
For example \code{x = "Hi {person}"} will  return \code{"person"}
(the variable that will be interpolated).}

\item{parse}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the result is a list of R
expressions. If \code{FALSE} (default), the result is a character vector of expressions.}

\item{delim}{Character vector of length 1 or 2. Default is \code{c("{", "}")}. Defines
the opening and the closing delimiters for interpolation.

If of length 1, it must be of the form: 1) the opening delimiter,
2) a single space, 3) the closing delimiter. Ex: \code{".[ ]"} is equivalent to \code{c(".[", "]")}.
The default value is equivalent to \code{"{ }"}.

[ ]: R:\%20
[", "]: R:\%22,\%20\%22}
}
\value{
If the argument \code{parse = FALSE}, the default, then this function returns a
character vector containing all the expressions that will be interpolated.
This vector can be empty if there is no interpolation.

If the argument \code{parse = TRUE}, then a list is returned, containing the R expressions.

The function \code{get_interpolated_vars} always return a character vector.
}
\description{
Tool intended for development: use \code{get_interpolated_expr} to obtain the list of expressions
which will be interpolated in a \code{\link[=string_magic]{string_magic()}} call.
The function \code{get_interpolated_vars} provides the variables instead.
}
\details{
Note that this function captures even deeply nested interpolations.
}
\section{Functions}{
\itemize{
\item \code{get_interpolated_vars()}: Obtain the variables used in \code{string_magic()} interpolations

}}
\examples{

# let's create a simple interpolation
x = c("Ken", "Barbie")
sma_expr = "{' loves 'c ? x}. But does {' love 'c ? rev(x)}?"
string_magic(sma_expr)

# We recover the two expressions
(char = get_interpolated_expr(sma_expr))

# same with parsing
(expr = get_interpolated_expr(sma_expr, parse = TRUE))

# see the difference
eval(char[[1]])
eval(expr[[1]])

# and only the variables:
get_interpolated_vars(sma_expr)

}
\seealso{
String operations: \code{\link[=string_is]{string_is()}}, \code{\link[=string_get]{string_get()}}, \code{\link[=string_clean]{string_clean()}}, \code{\link[=string_split2df]{string_split2df()}}.
Chain basic operations with \code{\link[=string_ops]{string_ops()}}. Clean character vectors efficiently
with \code{\link[=string_clean]{string_clean()}}.

Use \code{\link[=string_vec]{string_vec()}} to create simple string vectors.

String interpolation combined with operation chaining: \code{\link[=string_magic]{string_magic()}}. You can change \code{string_magic}
default values with \code{\link[=string_magic_alias]{string_magic_alias()}} and add custom operations with \code{\link[=string_magic_register_fun]{string_magic_register_fun()}}.

Display messages while benefiting from \code{string_magic} interpolation with \code{\link[=cat_magic]{cat_magic()}} and \code{\link[=message_magic]{message_magic()}}.

Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_magic}()},
\code{\link{string_magic_alias}()},
\code{\link{string_ops_alias}()},
\code{\link{string_vec_alias}()}
}
