% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposal_info.R
\name{print.proposal}
\alias{print.proposal}
\title{Print Method for proposal Objects}
\usage{
\method{print}{proposal}(x, ...)
}
\arguments{
\item{x}{A list generated using STORS' \code{build_proposal()} or \code{proposal_optimizer()} functions.}

\item{...}{Additional arguments passed to the \code{print} function.}
}
\value{
Prints a summary of the proposal's properties, but does not return any value.
}
\description{
The function displays detailed information about the proposal object created by STORS' \code{build_proposal()} or \code{proposal_optimizer()} functions.
This includes the number of steps within the proposal, the range of values covered by the proposal, and the proposal's sampling efficiency.
This information is crucial for understanding the structure and performance of the proposal in sampling processes.
}
\details{
This method extends the generic \code{print} function for objects of class \code{proposal}.
It prints the provided proposal's features such as the number of steps, steps limit, and efficiency.
}
\examples{
# Define the density function, its logarithm,
#and its derivative for the standard normal distribution
modes_norm = 0
f_norm <- function(x) { 1 / sqrt(2 * pi) * exp(-0.5 * x^2) }
h_norm <- function(x) { log(f_norm(x)) }
h_prime_norm <- function(x) { -x }

# Build a dense proposal for the standard normal distribution
norm_proposal = build_proposal(lower = -Inf, upper = Inf, mode = modes_norm,
 f = f_norm, h = h_norm, h_prime = h_prime_norm, steps = 1000)

# Print the properties of the generated proposal

print(norm_proposal)
}
