#include <Rcpp.h>
#include <Rmath.h>
#include <math.h>
#include "dvm.h"

//' @export
// [[Rcpp::export]]

double vmp_tpd(double dt,double theta,double theta_0,double lambda,double sigma,double mu){
  double kappa;
  kappa = 2*lambda/pow(sigma,2);

  double gamma;
  if(kappa<1000){
    gamma = kappa*R::bessel_i(kappa, 1, 1)/R::bessel_i(kappa, 0, 1);
  } else {
    gamma = kappa*(8*kappa-3)/(8*kappa+1);
  }

  double q;
  q = exp(-2*gamma*(pow(sigma,2)/2)*dt);

  // Truncation logic borrowed from R Circular package for wrappednormal, higher sigma
  // would require higher number of terms
  double cr;
  cr = (1-q)/(gamma*sqrt(q));
  double rr = 2*M_PI;
  double K = (rr+6*sqrt(cr))/(2*M_PI)+1;
  if(K<10){
    K = 10;
  }

  double s{0};
  for(int i=-K;i<(K+1);i++){
    s = s+exp(-gamma*sqrt(q)*pow(theta-theta_0+2*M_PI*i,2)/(2*(1-q)));
  }

  double term2;
  term2 = s;

  double p;

  double alt1;
  double alt2;
  double alt;
  if(kappa<1000){
    alt1 = pow(1/(2*M_PI*R::bessel_i(kappa, 0, 1)),(1-sqrt(q))/(1+sqrt(q)));
    alt2 = exp((kappa/(1+sqrt(q)))*(cos(theta-mu)-sqrt(q)*cos(theta_0-mu)));
    alt = alt1*alt2;
  } else {
    alt1 = pow(1/(2*M_PI*sqrt(2*M_PI*kappa)),(1-sqrt(q))/(1+sqrt(q)));
    alt2 = exp((kappa/(1+sqrt(q)))*(cos(theta-mu)-sqrt(q)*cos(theta_0-mu)-(1-sqrt(q))))/pow((1+(1/(8*kappa))),(1-sqrt(q))/(1+sqrt(q)));
    alt = alt1*alt2;
  }
  // p=term1*term2*term3;
  p=term2*alt;
  return(p);
}
