% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{stoch.bootstrap}
\alias{stoch.bootstrap}
\title{Bootstrap for stochcorr}
\usage{
stoch.bootstrap(est, S_1, S_2, boot_iter=500, p=0.05, seed = NULL)
}
\arguments{
\item{est}{object of class \code{cbm} or \code{vmp}}

\item{S_1}{historical price of the first asset}

\item{S_2}{historical price of the second asset}

\item{boot_iter}{number of bootstrap iteration (Default is 500)}

\item{p}{1-p\% confidence interval (Default is 0.05)}

\item{seed}{(optional) seed value}
}
\value{
Returns a matrix for the bootstrap (1-p)\% confidence interval for rho. The first row of the matrix is the lower bound and the second
row is the upper bound.
}
\description{
\code{stoch.bootstrap} returns the Bootstrap confidence interval for estimated rho from \code{stochcorr}.
}
\details{
This function returns a p\% confidence interval for estimated rho from \code{stochcorr}
using parametric bootstrap. See section 4 of Majumdar and Laha (2024) \url{doi:10.48550/arXiv.2412.06343}.
}
\examples{
\donttest{
library(stochcorr)

data("nse2020")

## using von Mises process as the correlation process

a <- stochcorr(nse2020$`USD/INR`, nse2020$Nifty, 1 / 250, corr_process = "vmp")
b <- stoch.bootstrap(a, nse2020$`USD/INR`, nse2020$Nifty, seed = 100)

rho_data <- as.data.frame(cbind(a$rho, nse2020$Date))
rho_data[, 2] <- as.Date(rho_data[, 2], origin = "1970-01-01")
colnames(rho_data) <- c("Correlation", "Time")

if(requireNamespace("ggplot2")){
library(ggplot2)
ggplot2::ggplot(rho_data, aes(x = Time, y = Correlation)) +
  theme_test() +
  theme(
    text = element_text(size = 15),
    axis.text.x = element_text(angle = 90, hjust = 1)
  ) +
  geom_line() +
  geom_ribbon(aes(ymin = b[1, ], ymax = b[2, ]), fill = "blue", alpha = 0.15) +
  scale_y_continuous(breaks = round(seq(-1, 1, by = 0.05), 1)) +
  scale_x_date(breaks = "1 month", date_labels = "\%B \%Y")
  }

## using Circular Brownian Motions as the correlation process

a <- stochcorr(nse2020$`USD/INR`, nse2020$Nifty, 1 / 250, corr_process = "cbm")
b <- stoch.bootstrap(a, nse2020$`USD/INR`, nse2020$Nifty, seed = 100)

rho_data <- as.data.frame(cbind(a$rho, nse2020$Date))
rho_data[, 2] <- as.Date(rho_data[, 2], origin = "1970-01-01")
colnames(rho_data) <- c("Correlation", "Time")

if(requireNamespace("ggplot2")){
library(ggplot2)
ggplot2::ggplot(rho_data, aes(x = Time, y = Correlation)) +
  theme_test() +
  theme(
    text = element_text(size = 15),
    axis.text.x = element_text(angle = 90, hjust = 1)
  ) +
  geom_line() +
  geom_ribbon(aes(ymin = b[1, ], ymax = b[2, ]), fill = "blue", alpha = 0.15) +
  scale_y_continuous(breaks = round(seq(-1, 1, by = 0.05), 1)) +
  scale_x_date(breaks = "1 month", date_labels = "\%B \%Y")}
  }
}
\seealso{
\code{\link[=stochcorr]{stochcorr()}}
}
