#' @export
#'
#' @title Probability transition density function for Circular Brownian Motion
#' @name dcbm
#' @description `dcbm` evaluates the transition density for Circular Brownian Motion
#' @usage dcbm(theta, t, theta_0, sigma)
#' @param theta vector of data
#' @param t time step \eqn{\Delta t}
#' @param theta_0 initial value
#' @param sigma sigma
#' @details See section 2 of Majumdar and Laha (2024) <doi:10.48550/arXiv.2412.06343>.
#' @return `dcbm` gives the transition density function of the circular Brownian motion


dcbm <- function(theta, t, theta_0, sigma) {
  nc <- length(theta)
  a <- rep(0, nc)
  for (i in 1:nc) {
    a[i] <- cbm_tpd(t, theta[i], theta_0, sigma)
  }
  return(a)
}
