% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superimpose.stlpp.R
\name{superimpose.stlpp}
\alias{superimpose.stlpp}
\title{Methods for spatio-temporal point patterns on a linear network}
\usage{
\method{superimpose}{stlpp}(...)
}
\arguments{
\item{...}{any number of arguments, each of which represents a spatio-temporal point pattern on a linear network}
}
\value{
An object of class \code{\link{stlpp}}.
}
\description{
Superimpose several spatio-temporal point patterns on a linear network.
}
\details{
This function is used to superimpose several spatio-temporal point patterns on a linear network, each of which of class \code{\link{stlpp}}. They should be one same linear network and have the same time interval.
}
\examples{
 
data(easynet)
X <- rpoistlpp(2, L = easynet, a = 0, b = 2)
Y <- rpoistlpp(2, L = easynet, a = 0, b = 2)
superimpose(X,Y)

}
\seealso{
\code{\link{stlpp}},
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
