% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.slope.gen}
\alias{size.ci.slope.gen}
\title{Sample size for a slope confidence interval in a general statistical model}
\usage{
size.ci.slope.gen(alpha, se, n0, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{se}{standard error of slope from prior/pilot study}

\item{n0}{sample size used in prior/pilot study}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a slope coefficient with
desired confidence interval precision in any type of statistical model.
This function requires a standard error estimate for the slope of interest
from a prior or pilot study and the sample size that was used in the prior
or pilot study. This function can be used for both unstandardized and
standardized slopes. This function also can be used for both unstandardized
and standardized factor loadings in a confirmatory factor analysis model.
This function will soon be replaced with size.ci.gen.
}
\examples{
size.ci.slope.gen(.05, 3.15, 50, 5)

# Should return:
#  Sample size
#          305
 

}
