% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.median2}
\alias{size.ci.median2}
\title{Sample size for a 2-group median difference confidence interval}
\usage{
size.ci.median2(alpha, var, w, R, dist)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}

\item{dist}{\itemize{
\item set to 1 for Normal distribution (skew = 0, kurtosis = 3)
\item set to 2 for Logistic distribution (skew = 0, kurtosis = 4.2)
\item set to 3 for Laplace distribution (skew = 0, kurtosis = 6)
\item set to 4 for Gamma(5) (skew = .89, kurtosis = 4.2)
\item set to 5 for Exponential distribution (skew = 2, kurtosis = 9)
}}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size for each group required to estimate a population
median difference with desired confidence interval precision in a 2-group
design. Set the variance planning value to the largest value within a
plausible range for a conservatively large sample size. The sample size
requirement depends on the shape of the distribution. Select one of the
four distribution options (Normal, Logistic, Laplace, Exponential) that
approximates the most likely distribution shape in the planned study.
Select the Normal distribution for a conservatively large sample size
requirement. Set R = 1 for equal sample sizes.
}
\examples{
size.ci.median2(.05, 37.1, 5, 1, 1)

# Should return:
# n1  n2
# 72  72

size.ci.median2(.05, 37.1, 5, 2, 4)

# Should return:
# n1  n2
# 51 102

}
\references{
\insertRef{Bonett2002}{statpsych}
}
