% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinners-dependencies.R, R/spinners-handler.R
\name{useSpinners}
\alias{useSpinners}
\alias{spinners}
\title{Single Element CSS Spinners}
\usage{
useSpinners()

spinners(uiOutput, type = 1, color = "#0275d8")
}
\arguments{
\item{uiOutput}{An output element to be wrapped within a spinner.}

\item{type}{Type of spinner to use. Any integer between \code{1} and \code{8} is valid.}

\item{color}{Color of the spinner. Choose between hexadecimal or keyword values.}
}
\value{
None
}
\description{
A collection of loading spinners animated with CSS
}
\section{Functions}{

\itemize{
\item \code{useSpinners}: Dependencies to include in your UI.
\item \code{spinners}: Display loading animation.
}
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useSpinners(),
      actionButton("render", "Render"),
      spinners(plotOutput("plot"))
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        input$render
        Sys.sleep(3)
        hist(mtcars$mpg)
      })
    }
  )
}

}
