% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.event_tree}
\alias{summary.event_tree}
\title{Summary of an Event Tree}
\usage{
\method{summary}{event_tree}(object, ...)
}
\arguments{
\item{object}{An object of class \code{event_tree}. This object should have a list structure with \code{eventtree} containing a nested list where \code{x} is a dataframe with \code{nodes} and \code{edges} attributes.}

\item{...}{Additional arguments passed to or from other methods (ignored).}
}
\value{
Prints a summary of the event tree to the console, including:
\itemize{
\item The number of nodes and the unique node levels
\item The number of edges and the unique labels in the edges
\item The labels of the edges, with newlines replaced by spaces
}
}
\description{
This function provides a summary of an object of class \code{event_tree}. It outputs key information about the nodes and edges of the event tree, including the number of nodes and edges, unique levels and labels, and the labels of the edges (with newlines replaced by spaces).
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
homicides_ET_summary <- summary(event_tree)
}
