% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sstn.R
\name{sstn}
\alias{sstn}
\title{Self-Similarity Test for Normality (SSTN)}
\usage{
sstn(
  x,
  B = 500,
  grid_length = 10,
  t_max = 4,
  M_max = 100,
  beta = 0.5,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{Numeric vector of observations \eqn{(x_1, \dots, x_n)} drawn from
a distribution with finite variance. Must have length \eqn{n \ge 2}.}

\item{B}{Integer. Number of Monte Carlo samples. Default is 500.}

\item{grid_length}{Integer. Number of grid points \eqn{H} for the evaluation
of the standardized characteristic function. Default is 10.}

\item{t_max}{Positive numeric. Upper bound of the grid \eqn{t_H}, typically 4
to cover the effective support of the normal characteristic function.
Default is 4.}

\item{M_max}{Integer. Maximum number of iterations \eqn{N}. Default is 100.}

\item{beta}{Positive numeric. Weighting parameter in the discrepancy measure.
Controls the decay rate of the exponential weight \eqn{\exp(-\beta t^2)}.
Default is 0.5.}

\item{seed}{Optional integer. Random seed for reproducibility of Monte Carlo samples.
Default is NULL (no fixed seed).}

\item{verbose}{Logical. If TRUE (default), prints a summary of the test results
including the number of summands, test statistic, and \eqn{p}-value.}
}
\value{
An invisible list with the following components:
\item{test_statistic}{Numeric. The observed value \eqn{d_{M}} of the SSTN test statistic.}
\item{null_distribution}{Numeric vector of length \code{B}. Test statistics
from the Monte Carlo samples under the null hypothesis.}
\item{number_summands}{Integer. The determined number of summands \eqn{M}.}
\item{p_value}{Numeric. The \eqn{p}-value of the test.}
}
\description{
The SSTN is a statistical test for assessing whether a given sample originates
from a normal distribution. It is based on the iterative application of the
empirical characteristic function and compares it to the characteristic function
of the standard normal distribution. A Monte Carlo procedure is used to obtain
the empirical distribution of the test statistic under the null hypothesis.
}
\examples{
set.seed(123)
# Sample from standard normal (null hypothesis true)
x <- rnorm(100)
res <- sstn(x)
res$p_value

# Sample from Gamma distribution (null hypothesis false)
y <- rgamma(100, 1)
res2 <- sstn(y)
res2$p_value
}
\references{
Anarat A. and Schwender, H. (2025). A normality test based on self-similarity. Submitted.
}
\author{
Akin Anarat \email{akin.anarat@hhu.de}
}
