% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/next_squids.R
\name{next_squid}
\alias{next_squid}
\alias{next_squids}
\title{Get the next SQUID (or SQUIDs)}
\usage{
next_squid(x, n = 1, followBy = NULL)
}
\arguments{
\item{x}{The SQUID or SQUIDs to follow (\code{follow} in the \code{\link[=squids]{squids()}}
function).}

\item{n}{The number of following SQUIDs you want}

\item{followBy}{When following a vector of SQUIDs, this can be used to
specify the distance between the two vectors in centiseconds.}
}
\value{
One or more SQUIDs
}
\description{
Get the next SQUID (or SQUIDs)
}
\examples{
exampleSQUID <-
  squids::squids(1);

exampleSQUID;

squids::next_squid(exampleSQUID);

### Or for multiple SQUIDs
exampleSQUIDs <-
  squids::squids(5);

exampleSQUIDs;

squids::next_squids(exampleSQUIDs, 3);
}
