% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_current_origin.R
\name{get_current_origin}
\alias{get_current_origin}
\title{Get the current origin for each reuse}
\usage{
get_current_origin(
  as = "time",
  suppressPrinting = FALSE,
  format = "\%Y-\%m-\%d \%H:\%M:\%S \%Z"
)
}
\arguments{
\item{as}{Whether to return the origin as \code{character} value (can
also be specified by passing \code{string} or \code{text}), as a \code{numeric}
value (can also be specified by passing \code{number}), or as \code{POSIX}
time (can also be specified by passing \code{time}).}

\item{suppressPrinting}{Whether to suppress printing the message
about how to store the origin in your R script.}

\item{format}{If returning \code{character}, the \code{format} to pass to
\code{\link[base:format]{base::format()}} when formatting the time to a character value}
}
\value{
The origin, in the format specified in \code{as}.
}
\description{
Get the current origin for each reuse
}
\examples{
squids::get_current_origin();

squids::get_current_origin(
  as = "number"
);

squids::get_current_origin(
  as = "time"
);
}
