% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_to_shorcid.R, R/shorcid_to_orcid.R
\name{orcid_to_shorcid}
\alias{orcid_to_shorcid}
\alias{shorcid_to_orcid}
\title{Converting ORCIDs to ShORCIDs and vice versa}
\usage{
orcid_to_shorcid(x)

shorcid_to_orcid(x, url = FALSE)
}
\arguments{
\item{x}{The ORCID(s) or ShORCID(s).}

\item{url}{Whether to also return the ORCID or the ORCID URL (including
the preceding "https://orcid.org/" bit)}
}
\value{
The ShORCID(s) or ORCID(s), as a character vector.
}
\description{
These functions produce ShORCIDs (Short ORCIDs) from ORCIDs and vice versa.
}
\details{
Conversion ORCID to ShORCID occurs by detaching the last character (the
checksum) and storing it. Then in the first string of characters, all
non-numbers are removed and the resulting number is converted to a base 30
system with \code{\link[=numericToBase30]{numericToBase30()}}. The checksum is then re-attached. This is
done separately because the checksum can be X (i.e. the only character in an
ORCID that's not necessarily numeric). Then, an 'i' is prepended to ensure
that the ShORCID starts with a letter. Conversion the other way around just
inverts the process (and so uses \code{\link[=base30toNumeric]{base30toNumeric()}}).
}
\examples{
squids::orcid_to_shorcid(
  "0000-0002-9540-5371"
);
squids::shorcid_to_orcid(
  "i16g2sk1"
);
}
