#' @details
#'
#' *sqlq* package.
#'
#' *sqlq* simplifies the creation of SQL queries, and ensure identifiers and
#' string values are correctly quoted.
#'
#' Global options used by *sqlq*:
#'
#' - sqlq_always_quote: If set to TRUE, token identifiers (table and column
#'                      names) will always be quoted.
#'
#' - sqlq_conn: Set the database connector to use for quoting identifiers and
#'              values. Default is DBI::ANSI().
#'
#' - sqlq_omit_kwd: If set to TRUE, optional SQL keywords (like INNER or OUTER)
#'                  will be omitted.
#'
#' - sqlq_spaces: If set to FALSE, try to avoid non-necessary spaces (e.g.:
#'                around operators or after a comma).
#'
#' - sqlq_uppercase: If set to FALSE, SQL keywords and alphabetical operators
#'              (e.g.: OR, AND, ...) will be written in lowercase.
#'
#' @examples
#'
#' options(sqlq_uppercase = FALSE)
#'
#' @seealso \link{options}.
#'
"_PACKAGE"

.SQL_KEYWORDS <- tolower(readLines(system.file('keywords.txt', package='sqlq')))

.onLoad <- function(libname, pkgname) {
  e <- parent.env(environment())

  # Define empty token
  assign(".void", TokenEmpty$new(), envir = e)

  # Define symbols
  smbls <- c(asterisk="*", coma=",", dot=".", lparen="(", rparen=")",
             semicolon=";", spc=" ")
  for (s in names(smbls))
    assign(paste0(".", s), TokenSymbol$new(smbls[s]), envir = e)

  # Define keywords
  for (kwd in .SQL_KEYWORDS)
    assign(paste0(".", kwd), TokenKeyword$new(kwd), envir = e)
}

NULL
