#' TokenSymbol class.
#'
#' Represents a SQL symbol such as *, +, -, /, =, <, >, etc.
#'
#' @examples
#' # No example since this class is not exported.
#'
#' @import R6
#' @include Token.R
TokenSymbol <- R6::R6Class("TokenSymbol",
  inherit = Token,
  public = list(

    #' @description
    #' Initializer.
    #' @param symbol The symbol.
    #' @return Nothing.
    initialize = function(symbol) {
      chk::chk_string(symbol)
      private$symbol <- symbol
      return(invisible(NULL))
    },

    #' @description
    #' Converts into a string.
    #' @return A string containing the SQL expression.
    toString = function() {
      return(private$symbol)
    }
  ),
  private = list(
    symbol = NULL
  )
)
