% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_matrix.R
\name{display_matrix}
\alias{display_matrix}
\title{Plot a matrix}
\usage{
display_matrix(object, palette = "RdYlBu", along = NULL, ...)
}
\arguments{
\item{object}{A matrix, a list of matrices, an object produced by 
\code{*_sews} functions or \code{indictest()}}

\item{palette}{A color palette to use in the plot. It can be any color 
palette understood by \link[ggplot2]{scale_fill_brewer}.}

\item{along}{A vector of values used in facet headers. If \code{object} is 
a matrix, this is ignored.}

\item{...}{Other arguments are ignored.}
}
\value{
A ggplot2 object, which is printed when this function is used 
  interactively.
}
\description{
Display a matrix or a list of matrices in a plot
}
\details{
This function will plot a matrix using ggplot2, using the provided 
  palette. Its use-case is very much like \code{image()}, but its produces 
  nicer plots by default (\code{image()} is much faster, however).
}
\examples{

# display_matrix works with single matrices or lists of matrices 
display_matrix(serengeti[2:3])

# display_matrix is compatible with "*_sews" objects
indics <- compute_indicator(serengeti[2:3], raw_moran) 
display_matrix(indics)

}
