% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_replace_na.R
\name{sparse_replace_na}
\alias{sparse_replace_na}
\title{Replace NAs with specified values in sparse vectors}
\usage{
sparse_replace_na(x, replace)
}
\arguments{
\item{x}{A sparse vector.}

\item{replace}{A single value.}
}
\value{
A sparse vector.
}
\description{
Replace NAs with specified values in sparse vectors
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.
The \code{replace} is likewise not type or length checked.

The output type will match the values after coercion happens during
replacement.
}
\examples{
sparse_replace_na(
  sparse_double(c(10, NA, 11), c(1, 5, 10), 10),
  5
)

sparse_replace_na(
  sparse_integer(c(10L, NA, 11L), c(1, 5, 10), 10),
  5L
)

sparse_replace_na(
  sparse_character(c("A", NA, "E"), c(2, 5, 10), 10),
  "missing"
)
}
