% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_gl_a.R
\name{span_gl_a}
\alias{span_gl_a}
\title{Gungor–Luger Alpha-Only Spanning Test (2016)}
\usage{
span_gl_a(R1, R2, control = list())
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times N}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times K}.}

\item{control}{List of options:
\describe{
  \item{\code{totsim}}{Number of MC simulations (default \code{500}).}
  \item{\code{pval_thresh}}{Significance level for decisions (default \code{0.05}).}
  \item{\code{do_trace}}{Logical; print progress (default \code{TRUE}).}
}}
}
\value{
A list with components:
\describe{
  \item{\code{pval_LMC}}{Least-Favorable MC p-value.}
  \item{\code{pval_BMC}}{Balanced MC p-value.}
  \item{\code{stat}}{Observed \eqn{F_{\max}} statistic.}
  \item{\code{Decisions}}{Decision code: \code{1} = Accept, \code{0} = Reject, \code{NA} = Inconclusive.}
  \item{\code{Decisions_string}}{Text label: \code{"Accept"}, \code{"Reject"}, or \code{"Inconclusive"}.}
  \item{\code{H0}}{Null hypothesis description, \code{"alpha = 0"}.}
}
}
\description{
Tests the null \eqn{H_0:\ \alpha = 0} that benchmark assets span the mean
(intercepts) of the test assets. Following Gungor & Luger (2016), the
procedure uses a Monte Carlo (MC) test based on an \eqn{F_{\max}} statistic
with residual sign-flip simulations, yielding Least-Favorable (LMC) and
Balanced (BMC) MC p-values and a three-way decision rule.
}
\details{
Accept if \code{pval_LMC > alpha}; Reject if \code{pval_BMC <= alpha};
otherwise Inconclusive. The subseries sign-flip MC approach is robust to
heteroskedasticity, serial dependence, and heavy tails, making it suitable
for high-dimensional settings where classical alpha tests (e.g., GRS) may
suffer from size distortions.
}
\examples{
set.seed(1234)
R1 <- matrix(rnorm(300), 100, 3)
R2 <- matrix(rnorm(200), 100, 2)
out <- span_gl_a(R1, R2, control = list(totsim = 100, do_trace = FALSE))
out$Decisions_string; out$pval_LMC; out$pval_BMC

}
\references{
\insertRef{GungorLuger2016}{spantest} \cr
}
\seealso{
Other Alpha Spanning Tests: 
\code{\link{span_bj}()},
\code{\link{span_f1}()},
\code{\link{span_grs}()},
\code{\link{span_py}()}
}
\concept{Alpha Spanning Tests}
