% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPS_combine}
\alias{BPS_combine}
\title{Combine subset models wiht BPS}
\usage{
BPS_combine(fit_list, K, rp)
}
\arguments{
\item{fit_list}{\link{list} K fitted model outputs composed by two elements each: first named \eqn{epd}, second named \eqn{W}}

\item{K}{\link{integer} number of folds}

\item{rp}{\link{double} percentage of observations to take into account for optimization (\code{default=1})}
}
\value{
\link{matrix} posterior predictive density evaluations (each columns represent a different model)
}
\description{
Combine subset models wiht BPS
}
\examples{
\donttest{
## Generate subsets of data
n <- 100
p <- 3
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- matrix(rnorm(n), nrow = n, ncol = 1)
crd <- matrix(runif(n*2), nrow = n, ncol = 2)
data_part <- subset_data(data = list(Y = Y, X = X, crd = crd), K = 10)

## Select competitive set of values for hyperparameters
delta_seq <- c(0.1, 0.2, 0.3)
phi_seq <- c(3, 4, 5)

## Perform Bayesian Predictive Stacking within subsets
fit_list <- vector(length = 10, mode = "list")
for (i in 1:10) {
    Yi <- data_part$Y_list[[i]]
    Xi <- data_part$X_list[[i]]
    crd_i <- data_part$crd_list[[i]]
    p <- ncol(Xi)
    bps <- spBPS::BPS_weights(data = list(Y = Yi, X = Xi),
                               priors = list(mu_b = matrix(rep(0, p)),
                                             V_b = diag(10, p),
                                             a = 2,
                                             b = 2), coords = crd_i,
                                             hyperpar = list(delta = delta_seq,
                                                             phi = phi_seq),
                                             K = 5)
     w_hat <- bps$W
     epd <- bps$epd
     fit_list[[i]] <- list(epd, w_hat) }

## Combination weights between partitions using Bayesian Predictive Stacking
comb_bps <- BPS_combine(fit_list = fit_list, K = 10, rp = 1)
}

}
