% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_structure.R
\name{nested_structure}
\alias{nested_structure}
\title{Automatically generate objects used to describe the structure of the nested group lasso penalty.}
\usage{
nested_structure(group_list)
}
\arguments{
\item{group_list}{A list containing the indices of the group members.}
}
\value{
A list of objects describing the group structure.
  \item{groups}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to describe the relationship between the \eqn{G} \code{overlapping} groups. A \eqn{G * G} integer matrix whose \eqn{(i,j)} entry is \code{1} if and only if \eqn{i\neq j} and \eqn{g_i} is a child group (subset) of \eqn{g_j}, and is \code{0} otherwise.}
  \item{own_variables}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to describe the relationship between the \eqn{G} \code{overlapping} groups and the \eqn{p} variables. The entries are the smallest variable indices in the groups (to achieve this, \code{group} is sorted. For any two groups \eqn{i} and \eqn{j}, if \eqn{i} is the parent group of \eqn{j}, then \eqn{i} is before \eqn{j} and vice versa, otherwise, the one with the smallest variable index is before the other.}
  \item{N_own_variables}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to describe the relationship between the \eqn{G} \code{overlapping} groups and the \eqn{p} variables. An integer vector of length \eqn{G} indicating the number of variables that are in each group but not in any of its child groups.}
  \item{group_weights}{Required by \code{\link{sox}()} and \code{\link{sox_cv}()} to specify the group-specific penalty weights. The weight is generated in a way such that, the penalty weights of all the groups that contain a given variable sum to 1 for all variables.}
}
\description{
Automatically generate objects used to describe the structure of the nested group lasso penalty. The output is then used by \code{\link{sox}()} and \code{\link{sox_cv}()}.
}
\examples{
# p = 9 Variables:
## 1: A1
## 2: A2
## 3: C1
## 4: C2
## 5: B
## 6: A1B
## 7: A2B
## 8: C1B
## 9: C2B

# G = 12 Nested groups (misspecified, for the demonstration of the software only.)
## g1: A1, A2, C1, C2, B, A1B, A2B, C1B, C2B
## g2: A1B, A2B, A1B, A2B
## g3: C1, C2, C1B, C2B
## g4: 1
## g5: 2
## ...
## G12: 9

nested.groups <- list(1:9,
                      c(1, 2, 6, 7),
                      c(3, 4, 8, 9),
                      1, 2, 3, 4, 5, 6, 7, 8, 9)

pars.nested <- nested_structure(nested.groups)

str(pars.nested)
                
}
