% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{.getPitchZc}
\alias{.getPitchZc}
\title{Zero-crossing rate per sound}
\usage{
.getPitchZc(
  audio,
  pitchFloor,
  pitchCeiling,
  zcThres,
  zcWin = 5,
  silence = 0.04,
  env = NULL,
  envWin = 5,
  certMethod = c("autocor", "variab")[2]
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{pitchFloor, pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{zcThres}{pitch candidates with certainty below this value are treated
as noise and set to NA (0 = anything goes, 1 = pitch must be perfectly
stable over \code{zcWin})}

\item{zcWin}{certainty in pitch candidates depends on how stable pitch is
over \code{zcWin} glottal cycles (odd integer > 3)}

\item{silence}{minimum root mean square (RMS) amplitude, below which pitch
candidates are set to NA (NULL = don't consider RMS amplitude)}

\item{env}{precalculated envelope (when called internally by .analyze())}

\item{envWin}{window length for calculating RMS envelope, ms}

\item{certMethod}{method of calculating pitch certainty: 'autocor' =
autocorrelation of pitch estimates per zc over window (a measure of curve
smoothness), 'variab' = variability of pitch estimates per zc over window}
}
\description{
Internal soundgen function called by \code{\link{getPitchZc}}.
}
\keyword{internal}
