% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_search.R
\name{GlobalSearch.search}
\alias{GlobalSearch.search}
\title{GlobalSearch.search}
\usage{
GlobalSearch.search(paginate = FALSE, env = .solveEnv, ...)
}
\arguments{
\item{paginate}{When set to TRUE, retrieves all records (memory permitting).}

\item{env}{(optional) Custom client environment.}

\item{...}{(optional) Additional query parameters (e.g. filters, entities, query, limit, offset).}
}
\description{
Performs a Global Search based on provided filters, entities, queries, and returns an R data frame containing results from API response.
Returns a single page of results otherwise (default).
}
\examples{
\dontrun{
# No filters applied
GlobalSearch.search()

#Global Beacon search
GlobalSearch.search(entities = '[["gene","BRCA2"]]')

GlobalSearch.search(filters = '[{"and":[["type__in",["vault"]]]}]')

# Advanced search
GlobalSearch.search(query = "fuji")
}

}
\references{
\url{https://docs.solvebio.com/}
}
