% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{six_bucket_remove_user}
\alias{six_bucket_remove_user}
\title{Remove a user from a bucket}
\usage{
six_bucket_remove_user(bucket, username)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{username}{(character) A user name. required}
}
\value{
invisibly returns nothing
}
\description{
Remove a user from a bucket
}
\details{
This function detaches a policy from a user for accessing
the bucket; the policy itself is untouched
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a bucket
bucket <- random_bucket()
if (!aws_bucket_exists(bucket)) aws_bucket_create(bucket)

# create user
user <- random_user()
if (!aws_user_exists(user)) aws_user_create(user)

six_bucket_add_user(bucket, user, permissions = "read")
six_bucket_remove_user(bucket, user)

# cleanup
six_user_delete(user)
aws_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
