% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.R
\name{aws_role}
\alias{aws_role}
\title{Get a role}
\usage{
aws_role(name)
}
\arguments{
\item{name}{(character) the role name}
}
\value{
a named list with slots for:
\itemize{
\item role (tibble)
\item policies (character)
\item attached_policies (tibble)
}
}
\description{
Get a role
}
\details{
see docs \url{https://www.paws-r-sdk.com/docs/iam_get_role/};
also includes policies and attached policies by calling \code{list_role_policies}
and \code{list_attached_role_policies}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
trust_policy <- list(
  Version = "2012-10-17",
  Statement = list(
    list(
      Effect = "Allow",
      Principal = list(
        Service = "lambda.amazonaws.com"
      ),
      Action = "sts:AssumeRole"
    )
  )
)
doc <- jsonlite::toJSON(trust_policy, auto_unbox = TRUE)
desc <- "Another test role"
z <- aws_role_create("ALittleRole",
  assume_role_policy_document = doc,
  description = desc
)
aws_policy_attach(z, "ReadOnlyAccess")
res <- aws_role(name = "ALittleRole")
res
res$role
res$policies
res$attached_policies

# cleanup
aws_role("ALittleRole") \%>\%
  aws_policy_detach("ReadOnlyAccess")
aws_role_delete("ALittleRole")
\dontshow{\}) # examplesIf}
}
\seealso{
Other roles: 
\code{\link{aws_role_create}()},
\code{\link{aws_role_delete}()},
\code{\link{aws_role_exists}()},
\code{\link{aws_roles}()}
}
\concept{roles}
