% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policies}
\alias{aws_policies}
\title{List policies}
\usage{
aws_policies(refresh = FALSE, ...)
}
\arguments{
\item{refresh}{(logical) refresh results? default: \code{FALSE}. to invalidate
cache and refresh policy data, set \code{refresh=TRUE}}

\item{...}{named arguments passed on to
\href{https://www.paws-r-sdk.com/docs/iam_list_policies/}{list_policies}}
}
\value{
A tibble with information about policies. Each row is a policy.
Columns:
\itemize{
\item PolicyName
\item PolicyId
\item Path
\item Arn
\item CreateDate
\item UpdateDate
\item AttachmentCount
\item PermissionsBoundaryUsageCount
\item IsAttachable
\item Description
\item Tags
}
}
\description{
List policies
}
\details{
uses \code{memoise} internally to cache results to speed up all
subsequent calls to the function
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# takes a while on the first execution in an R session
aws_policies()
\dontshow{\}) # examplesIf}
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# faster because first call memoised the result
aws_policies()
# refresh=TRUE will pull from AWS
aws_policies(refresh = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
