% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_rename}
\alias{aws_file_rename}
\title{Rename remote files}
\usage{
aws_file_rename(remote_path, new_remote_path, ...)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}

\item{new_remote_path}{(character) one or more remote S3 paths. required.
length must match \code{remote_path}}

\item{...}{named parameters passed on to \code{\link[s3fs:s3_file_move]{s3fs::s3_file_move()}}}
}
\value{
vector of paths, length matches \code{length(remote_path)}
}
\description{
Rename remote files
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket <- random_bucket()
aws_bucket_create(bucket)

# rename files
tfiles <- replicate(n = 3, tempfile())
for (i in tfiles) cat("Hello\nWorld\n", file = i)
paths <- s3_path(bucket, c("aaa", "bbb", "ccc"), ext = "txt")
aws_file_upload(tfiles, paths)
new_paths <- s3_path(bucket, c("new_aaa", "new_bbb", "new_ccc"),
  ext = "txt"
)
aws_file_rename(paths, new_paths)

# Cleanup
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_copy}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
