% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_compose_raster.R
\name{compose_raster}
\alias{compose_raster}
\title{Compose a Raster Layer from Multiple Files}
\usage{
compose_raster(dir, out_file = NULL)
}
\arguments{
\item{dir}{A string or vector of strings representing folder names containing
raster files.}

\item{out_file}{A string specifying the output file name (without extension).
If `NULL`, a temporary file is used.}
}
\value{
A `SpatRaster` object from the `terra` package.
}
\description{
Combines multiple raster files into a single virtual raster layer (VRT).
It accepts one or more folder names containing raster files and creates a
virtual raster file.
If no output file name is provided, a temporary file is used.
}
\examples{
input_dir <- system.file("extdata", "mdt", package = "sigugr")

r <- compose_raster(input_dir)

}
\seealso{
Other transform raster functions: 
\code{\link{aggregate_rasters}()}
}
\concept{transform raster functions}
