% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTVPVAR.R
\name{simTVPVAR}
\alias{simTVPVAR}
\title{Generate synthetic data from a TVP-VAR-SV model}
\usage{
simTVPVAR(
  N = 200,
  p = 2,
  m = 3,
  prob_0_beta = 0.8,
  prob_0_theta = 0.8,
  simsig2_theta_sr = 0.2,
  simsig2_beta_mean = 0.2,
  intercept = TRUE,
  display_progress = TRUE
)
}
\arguments{
\item{N}{integer > 2. Indicates the length of the time series to be
generated. The default value is 200.}

\item{p}{integer > 0. Indicates the number of lags in the VAR model. The default value is 2.}

\item{m}{integer > 1. Indicates the number of equations in the VAR model. The default value is 3.}

\item{prob_0_beta}{numeric. Indicates the probability of a zero element in the beta_mean matrix. Can be a single value or a vector of length p.
The default value is 0.8.}

\item{prob_0_theta}{numeric. Indicates the probability of a zero element in the theta matrix. Can be a single value or a vector of length p.
The default value is 0.8.}

\item{simsig2_theta_sr}{numeric. Indicates the standard deviation of the normal distribution from which the elements of the theta matrix are drawn.
The default value is 0.2.}

\item{simsig2_beta_mean}{numeric. Indicates the standard deviation of the normal distribution from which the elements of the beta_mean matrix are drawn.
The default value is 0.2.}

\item{intercept}{logical. Indicates whether an intercept should be included in the model. The default value is TRUE.}

\item{display_progress}{logical. Indicates whether a progress bar should be displayed. The default value is TRUE.}
}
\value{
The value returned is a list object containing:
\itemize{
 \item \code{data:} data frame that holds the simulated data.
 \item \code{true_vals:} list object containing:
  \itemize{
   \item \code{Phi:} array containing the true VAR coefficients.
   \item \code{Sigma:} array containing the true covariance matrices.
   \item \code{theta_sr:} array containing the true standard deviations of the theta matrix.
   \item \code{beta_mean:} array containing the true means of the beta matrix.
  }
}
}
\description{
\code{simTVPVAR} generates synthetic data from a TVP-VAR-SV model. The data is always generated as to be stationary.
This is done via a trial and error approach, where the VAR coefficients are drawn from the data generating process until
the VAR process is stationary. As such, very large models might take a long time to generate.
}
\examples{
\donttest{
# Generate a time series of length 300
res <- simTVPVAR(N = 300, m = 3, p = 3)

# Estimate a model
model <- shrinkTVPVAR(y = res$data, p = 3)
}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
