% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gen_TVP_params}
\alias{gen_TVP_params}
\title{Generate TVP_params that can be used as input for a TVP-VAR-SV model}
\usage{
gen_TVP_params(m = 2, for_each_eq = TRUE)
}
\arguments{
\item{m}{The number of equations in the VAR model. Ignored if \code{for_each_eq} is set to FALSE.
The default value is 2.}

\item{for_each_eq}{Logical. If TRUE, a list of lists is returned, where each list contains the
hyperparameters for one equation. If FALSE, a single list is returned.}
}
\value{
Either a list containing the hyperparameters for all equations or a list of lists
containing the hyperparameters for each equation individually.
}
\description{
\code{gen_TVP_params} creates either a list or a list of lists of hyperparameters
in the correct format to be used as input for a TVP-VAR-SV model estimated by \code{\link{shrinkTVPVAR}}.
}
\examples{
# For a 5 equation model
params <- gen_TVP_params(m = 5)

# For a model where all equations share the same hyperparameters
params <- gen_TVP_params(for_each_eq = FALSE)

}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
