% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{density_plotter}
\alias{density_plotter}
\title{Kernel density plots of posterior distribution for hyperparameters of time-varying coefficient matrix in a TVP-VAR model}
\usage{
density_plotter(
  x,
  lag = 1,
  mgp = c(1.5, 0.5, 0),
  ylim,
  xlim,
  ylabs,
  mains,
  h_borders = c(0.075, 0.05),
  w_borders = c(0.05, 0.05),
  ...
)
}
\arguments{
\item{x}{\code{mcmc.var} object}

\item{lag}{single integer value, indicating the lag of the time-varying VAR to be plotted. The default value is 1.}

\item{mgp}{vector of length 3, determining the margin line (in \code{\link[graphics]{par}}) for the plot. The default value is \code{c(1.5, 0.5, 0)}.
See \code{\link[graphics]{par}} for more information.}

\item{ylim}{numeric vector of length 2, determining the y-axis limits of the plot.
If missing, the limits are determined by the \code{density} function.}

\item{xlim}{numeric vector of length 2, determining the x-axis limits of the plot.
If missing, the limits are determined by the minimum and maximum values of the data.}

\item{ylabs}{character vector of length m, determining the y-axis labels of the plot.
If missing, the labels are taken from the column names of the data.}

\item{mains}{character vector of length m, determining the main titles of the plot.
If missing, the titles are taken from the column names of the data.}

\item{h_borders}{numeric vector of length 2, determining the horizontal borders of the plot.
The first value is the space between the plot and the left border,
the second value is the space between the plot and the right border.
Both are fractions of the total width of the plot. The default value is \code{c(0.075, 0.05)}.}

\item{w_borders}{numeric vector of length 2, determining the vertical borders of the plot.
The first value is the space between the plot and the top border,
the second value is the space between the plot and the bottom border.
Both are fractions of the total height of the plot. The default value is \code{c(0.05, 0.05)}.}

\item{...}{further arguments to be passed to \code{\link[graphics]{plot}}.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{density_plotter} plots empirical kernel density estimates of the posterior distribution for hyperparameters
of a time-varying parameter coefficient matrix in a TVP-VAR model. \code{beta_mean} and \code{theta_sr} will most
likely be of interest here.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)
plot(res$theta_sr)

# Plot second lag
plot(res$theta_sr, lag = 2)
}
}
\seealso{
Other plotting functions: 
\code{\link{TV_heatmap}()},
\code{\link{plot.mcmc.tvp.var}()},
\code{\link{plot.mcmc.var}()},
\code{\link{plot.shrinkTVPVAR}()},
\code{\link{plot.shrinkTVPVAR_fit}()},
\code{\link{plot.shrinkTVPVAR_forc}()},
\code{\link{state_plotter}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
