% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CountOrthologs.R
\name{CountOrthologs}
\alias{CountOrthologs}
\title{Count Ortholog Genes in a Species}
\usage{
CountOrthologs(atomic.df, species)
}
\arguments{
\item{atomic.df}{A data frame containing information about ortholog genes.
It should have the following columns:
- multiplicon: The multiplicon identifier.
- geneX: The gene identifier in speciesX.
- speciesX: The species name for geneX.
- listX: The chromosome or list identifier for geneX.
- coordX: The coordinate information for geneX.
- geneY: The gene identifier in speciesY.
- speciesY: The species name for geneY.
- listY: The chromosome or list identifier for geneY.
- coordY: The coordinate information for geneY.
- level: The orthology level.
- num_anchors: The number of anchors.
- is_real: A flag indicating if the data is real.
- Ks: The Ks value.}

\item{species}{The species for which ortholog gene counts should be computed.}
}
\value{
A data frame summarizing the counts of ortholog genes for each chromosome.
}
\description{
This function counts ortholog genes in a given species based on input data.
}
