% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{code_block}
\alias{code_block}
\alias{code}
\title{code}
\usage{
code_block(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI code component.
}
\description{
Code is a component used to display inline code.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"sm"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"sm"}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  div(
    class = "flex gap-2 my-2",
    code_block(
      size = "lg",
      color = "secondary",
      radius = "full",
      "npm install @nextui-org/react"
    )
  )
)

server <- function(input, output, session) {

}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/code}.
}
