% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{card}
\alias{card}
\alias{card_body}
\alias{card_header}
\alias{card_footer}
\title{card}
\usage{
card(...)

card_body(...)

card_header(...)

card_footer(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI card component.
}
\description{
Card is a container for text, photos, and actions in the context of a single subject.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode OR ReactNode[]}. Default: \code{NA}.
\item \bold{shadow}. Type: \code{none OR sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isHoverable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isPressable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isBlurred}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isFooterBlurred}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableRipple}. Type: \code{boolean}. Default: \code{false}.
\item \bold{allowTextSelectionOnPress}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'header' OR 'body' OR 'footer', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onPress}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressStart}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressEnd}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressChange}. Type: \code{(isPressed: boolean) => void}. Default: \code{NA}.
\item \bold{onPressUp}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  div(
    class = "grid gap-4 grid-cols-3 grid-rows-3 m-5",
    card(card_body("Simple card without anything")),
    card(
      variant = "bordered",
      card_header("Card title"),
      divider(),
      card_body(h1("Card body")),
      divider(),
      card_footer("Card Footer")
    ),
    card(
      #isBlurred = TRUE,
      isPressable = TRUE,
      onPress = JS("() => alert('You pressed me')"),
      shadow = "sm",
      className = "border-none bg-background/60 dark:bg-default-100/50 max-w-[610px]",
      card_body("Press me!")
    )
  )
)

server <- function(input, output, session) {

}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/card}.
}
