% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/components.R, R/doc.R, R/inputs.R
\name{actionButton}
\alias{actionButton}
\alias{updateActionButton}
\alias{button}
\alias{action_button}
\alias{update_action_button}
\title{Action button}
\usage{
actionButton(inputId, label, icon = NULL, width = NULL, ...)

updateActionButton(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  icon = NULL
)

button(...)

action_button(inputId, ..., value = default_value)

update_action_button(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional \code{\link[shiny:icon]{icon()}} to appear on the button.}

\item{width}{Not used with NextUI but left for compatibility.}

\item{...}{Named attributes to be applied to the button or link.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}

\item{value}{Starting value.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).

An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI button component.
}
\description{
This is a higher level wrapper of \link{action_button} to match
vanilla's Shiny syntax and parameters.

This is a higher level wrapper of \link{update_action_button} to match
vanilla's Shiny syntax and parameters.

Buttons allow users to perform actions and choose with a single tap.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{variant}. Type: \code{solid OR bordered OR light OR flat OR faded OR shadow OR ghost}. Default: \code{"solid"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{spinner}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{spinnerPlacement}. Type: \code{start OR end}. Default: \code{"start"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isIconOnly}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isLoading}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableRipple}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
}
\itemize{
\item \bold{onPress}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressStart}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressEnd}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressChange}. Type: \code{(isPressed: boolean) => void}. Default: \code{NA}.
\item \bold{onPressUp}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onKeyDown}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onKeyUp}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onClick}. Type: \code{MouseEventHandler}. Default: \code{NA}.
}
\itemize{
\item \bold{children}. Type: \code{ReactNode OR ReactNode[]}. Default: \code{NA}.
\item \bold{variant}. Type: \code{solid OR bordered OR light OR flat OR faded OR shadow OR ghost}. Default: \code{"solid"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"xl"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  reactOutput("button")
)

server <- function(input, output, session) {
  n_click <- reactiveVal(0)
  observeEvent(input$clicked, {
    n_click(n_click() + 1)
  })

  output$button <- renderReact({
    action_button(
      inputId = "clicked",
      color = "primary",
      shadow = TRUE,
      sprintf(
        "Test Button. You clicked: \%s times.",
        n_click()
      )
    )
  })

  exportTestValues(n_click = n_click())
}

if (interactive() || is_testing()) shinyApp(ui, server)
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  reactOutput("button")
)

server <- function(input, output, session) {
  n_click <- reactiveVal(0)
  observeEvent(input$clicked, {
    n_click(n_click() + 1)
  })

  output$button <- renderReact({
    action_button(
      inputId = "clicked",
      color = "primary",
      shadow = TRUE,
      sprintf(
        "Test Button. You clicked: \%s times.",
        n_click()
      )
    )
  })

  exportTestValues(n_click = n_click())
}

if (interactive() || is_testing()) shinyApp(ui, server)
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  reactOutput("button")
)

server <- function(input, output, session) {
  n_click <- reactiveVal(0)
  observeEvent(input$clicked, {
    n_click(n_click() + 1)
  })

  output$button <- renderReact({
    action_button(
      inputId = "clicked",
      color = "primary",
      shadow = TRUE,
      sprintf(
        "Test Button. You clicked: \%s times.",
        n_click()
      )
    )
  })

  exportTestValues(n_click = n_click())
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/button}
and \link{action_button} to get the list of possible parameters.

See \url{https://heroui.com/docs/components/button}.
}
